function MqCheckInOutExt(iFldID_Status, iFldID_AllocatedToPerson, iFldID_RequestedUntil, iFldID_CurrentLocation, 
							iFldID_SendForRepair, iFldID_StorageLocation, iFldID_CheckIn, iFldID_CheckInAsset, iFldID_CheckOutAsset, 
							iFldID_ToBeDeleted, oCenMn)
{			
	var _me = this;
	var CHECKIN_ARROW = "checkInArrow";
	var CHECKOUT_ARROW = "checkOutArrow";
	var m_lngExchangeToID=0;
	var m_strExchangeTo="";
	var m_strExchangeFrom="";
	var m_CenMainWin=oCenMn;
	var m_oFldVals=g_VWS.RecordMgr().CurrentRecord().FldVals;

	var STATUS_ASSIGNED="1";
	var STATUS_STORAGE="2";
	var STATUS_REPAIR="5";
	var STATUS_LOST="4";
	var STATUS_STATUS_REQUESTED="11";
	var STATUS_TO_BE_SCRAPPED="12";
	var YES_VALUE="1";
	var NO_VALUE="2";
	var FLD_STATUS=iFldID_Status;
	var FLD_ALLOCATED_TO=iFldID_AllocatedToPerson;
	var FLD_REQUESTED_UNTIL=iFldID_RequestedUntil;
	var FLD_CURRENT_LOCATION=iFldID_CurrentLocation;
	var FLD_SEND_FOR_REPAIR=iFldID_SendForRepair;
	var FLD_STORAGE_LOCATION=iFldID_StorageLocation;
	var FLD_CHECK_IN=iFldID_CheckIn;
	var FLD_CHECK_IN_ASSET=iFldID_CheckInAsset;
	var FLD_CHECK_OUT_ASSET=iFldID_CheckOutAsset;
	var FLD_TO_BE_DELETED=iFldID_ToBeDeleted;
															  
	
	function OnAfterLoadRec()
	{
		if(g_VWS)
		{
			var sStatus=m_oFldVals(FLD_STATUS).GetValue();
			
			SetHeader(sStatus);
			
			if(m_lngExchangeToID>0){
				if(m_oFldVals(FLD_CHECK_IN_ASSET)){		
					m_oFldVals(FLD_CHECK_IN_ASSET).SetValue(m_strExchangeFrom);
					m_oFldVals(FLD_CHECK_IN_ASSET).HideElement(false, null, true, FLD_CHECK_IN_ASSET, GetRecDocument());
				}
				if(m_oFldVals(FLD_CHECK_OUT_ASSET)){		
					m_oFldVals(FLD_CHECK_OUT_ASSET).SetValue(m_strExchangeTo);
					m_oFldVals(FLD_CHECK_OUT_ASSET).HideElement(false, null, true, FLD_CHECK_OUT_ASSET, GetRecDocument());
				}
			}else{
				if(m_oFldVals(FLD_CHECK_IN_ASSET)){		
					m_oFldVals(FLD_CHECK_IN_ASSET).HideElement(true, null, true, FLD_CHECK_IN_ASSET, GetRecDocument());
				}			
				if(m_oFldVals(FLD_CHECK_OUT_ASSET)){		
					m_oFldVals(FLD_CHECK_OUT_ASSET).HideElement(true, null, true, FLD_CHECK_OUT_ASSET, GetRecDocument());
				}
			}
			
			if(sStatus==STATUS_ASSIGNED || sStatus==STATUS_LOST || sStatus==STATUS_STATUS_REQUESTED) //Assigned, Lost, Status Requested
			{
				if(m_lngExchangeToID>0)
				{
					SetSaveButtonText("BUTTON_EXCHANGE", "TOOLTIP_EXCHANGE");				
				}else{
					SetSaveButtonText("BUTTON_CHECKIN", "TOOLTIP_CHECKIN");					
				}
				
				
				_me.OnLoad_CheckIn();	  
	
				if(m_oFldVals(FLD_CHECK_IN)){		
					m_oFldVals(FLD_CHECK_IN).SetValue(YES_VALUE);
					var objCheckInElem=m_oFldVals(FLD_CHECK_IN).GetElement();
					if(objCheckInElem){
						if(objCheckInElem.onchange){
							objCheckInElem.onchange();
						}
					}
				}
			}else //if (sStatus==STATUS_STORAGE)  // Storage
			 {
				SetSaveButtonText("BUTTON_CHECKOUT", "TOOLTIP_CHECKOUT");			   
																												   
				if(m_oFldVals(FLD_CHECK_IN)){		
					m_oFldVals(FLD_CHECK_IN).SetValue(NO_VALUE);
				}
				_me.OnLoad_CheckOut();
			}
		}	
	}
	
	
	function OnLoad_CheckIn()
	{
		var oVNRec=g_VWS.RecordMgr().CurrentRecord();
		var oPersonFld=oVNRec.GetFormField(FLD_ALLOCATED_TO);
		var FEATURE_SHOW_STORAGE_LOCATION=138;
		
		var bHide=!g_VWS.FeatureExists(FEATURE_SHOW_STORAGE_LOCATION);
		
		if(m_oFldVals(FLD_STORAGE_LOCATION))
		{
			// Hide or Show
			m_oFldVals(FLD_STORAGE_LOCATION).HideElement(bHide, null, true, FLD_STORAGE_LOCATION, GetRecDocument());
		}
				
		var sStorageLoc=m_oFldVals(FLD_STORAGE_LOCATION).GetValue();
		if(m_oFldVals(FLD_CURRENT_LOCATION))
		{
			if(sStorageLoc!="")
			{
				m_oFldVals(FLD_CURRENT_LOCATION).SetValue(sStorageLoc);
			}
		}				
		
		// Disable selecting the assignee
		oPersonFld.Disable();
		oPersonFld.SetCaption(g_MqRef.RESX["CHECK_IN_OUT.ASSIGNED_TO"]);
	
		SetArrowAndCheckIn_OutAssetPictureUI(true);														
	}
	
	function OnLoad_CheckOut()
	{
		var oVNRec=g_VWS.RecordMgr().CurrentRecord();
		var oPersonFld=oVNRec.GetFormField(FLD_ALLOCATED_TO);

			// Never show the storage location when checking out (the Location usually indicates that anyway)
		if(m_oFldVals(FLD_STORAGE_LOCATION))
		{		
					m_oFldVals(FLD_STORAGE_LOCATION).HideElement(true, null, true, FLD_STORAGE_LOCATION, GetRecDocument());
		}
		
		oPersonFld.Enable();
		oPersonFld.SetCaption(g_MqRef.RESX["CHECK_IN_OUT.ASSIGN_TO"]);
		
		SetArrowAndCheckIn_OutAssetPictureUI(false);
				   
	}
	
	function saveBefore(objExtHdlrTemp)
	{
		var sStatus=m_oFldVals(FLD_STATUS).GetValue();
		var sSendForRepair=m_oFldVals(FLD_SEND_FOR_REPAIR).GetValue();
		var USER_NONE="0";
		var sScrapAsset=m_oFldVals(FLD_TO_BE_DELETED).GetValue();
		var blnScrapAsset=false;
		
		if(sScrapAsset=="1"){
			var strMsg=g_MqRef.RESX["CHECK_IN_OUT.CONFIRM_SCRAP"];
			if(window.confirm(strMsg))
			{
				blnScrapAsset=true;
			}else{
				objExtHdlrTemp.SetCancelProcess(true);
			}				
		}
		
		if(sStatus==STATUS_ASSIGNED || sStatus==STATUS_LOST || sStatus==STATUS_STATUS_REQUESTED) //Assigned, Lost, Status Requested
		{
			// Check in 
			var blnContinue=true;
			
			if(m_lngExchangeToID>0){
				//copy the status, assigned to person and current location from the current record to the m_lngExchangeToID
				if(m_CenMainWin){
					if(m_CenMainWin.objRecord){
						var lngSrcID=m_CenMainWin.objRecord.GetRecordId();
						var lngTgtID=m_lngExchangeToID;
						var strFields="882;865;11;1087;" + FLD_CURRENT_LOCATION;
						var strURL="FLDS=" + g_MqRef.MqStr.MqEncodeURIComponent(strFields) + 
										"&SRC=" + lngSrcID + "&TGT=" + lngTgtID;
						var co = m_CenMainWin.objRequest.Post(m_CenMainWin.mstrCurrentLocation + "../ASP/SetVals.asp", strURL);
						
						if (co==lngTgtID){
							m_lngExchangeToID=0;
							m_strExchangeTo="";
							m_strExchangeFrom="";
						}else{
							g_MqRef.AlertBox.show(g_MqRef.RESX["TITLE_CANT_EXCHANGE"], g_MqRef.RESX["MSG_CANT_EXCHANGE"]);
							blnContinue=false;
						}				
					}
				}
			}
			
			if(blnContinue){
				// Set the owner to nothing
				if(m_oFldVals(FLD_ALLOCATED_TO)){		
					m_oFldVals(FLD_ALLOCATED_TO).SetValue(USER_NONE);
				}
				if(m_oFldVals(FLD_STATUS)){	
					if(sSendForRepair=="1"){
						//set status to in repair
						m_oFldVals(FLD_STATUS).SetValue(STATUS_REPAIR);
						
						//clear the checkbox so we don't save it in the asset
						if(m_oFldVals(FLD_SEND_FOR_REPAIR)){		
							m_oFldVals(FLD_SEND_FOR_REPAIR).SetValue("");
						}
					}else{
						if(blnScrapAsset){
							//set status to be scrapped
							m_oFldVals(FLD_STATUS).SetValue(STATUS_TO_BE_SCRAPPED);
						}else{
							m_oFldVals(FLD_STATUS).SetValue(STATUS_STORAGE);
						}
					}
				}
				//clear the requested until
				if(m_oFldVals(FLD_REQUESTED_UNTIL)){		
					m_oFldVals(FLD_REQUESTED_UNTIL).SetValue("");
				}
				//clear the current location or set to the storage location
				var sStorageLoc=m_oFldVals(FLD_STORAGE_LOCATION).GetValue();
				if(m_oFldVals(FLD_CURRENT_LOCATION))
				{
					if(sStorageLoc!=""){
						m_oFldVals(FLD_CURRENT_LOCATION).SetValue(sStorageLoc);
					}else{
						m_oFldVals(FLD_CURRENT_LOCATION).SetValue("");
					}
				}
				//clear the storage location
				if(m_oFldVals(FLD_STORAGE_LOCATION)){		
					m_oFldVals(FLD_STORAGE_LOCATION).SetValue("");
				}
			}
		}
		else
		{
			// Check out
			// Ensure it is allocated to someone
			var sVal=m_oFldVals(FLD_ALLOCATED_TO).GetValue();
			
			if (sVal==USER_NONE || sVal=="")
			{
				g_MqRef.MsgHlpr.DisplayMessage(g_MqRef.RESX["MSG_NEED_PERSON_TO_ALLOCATE"]); 
				objExtHdlrTemp.SetCancelProcess(true);
				
			}
			else
			{
				m_oFldVals(FLD_STATUS).SetValue(STATUS_ASSIGNED);
				
			}
		}
		
		if(m_oFldVals(FLD_CHECK_IN)){		
			m_oFldVals(FLD_CHECK_IN).SetValue("");
		}
		
		if(m_oFldVals(FLD_CHECK_IN_ASSET)){		
			m_oFldVals(FLD_CHECK_IN_ASSET).SetValue("");
		}
		
		if(m_oFldVals(FLD_CHECK_OUT_ASSET)){		
			m_oFldVals(FLD_CHECK_OUT_ASSET).SetValue("");
		}
		
		return objExtHdlrTemp;
	}
	
	function saveAfter()
	{
		g_VWS.SummaryList().SLSearch().SetFocus(true);		
	}
	
	function cancelAfter()
	{
		m_lngExchangeToID=0;
		m_strExchangeTo="";
		m_strExchangeFrom="";
	}
	
	function setExchangeAsset(lngExchangeToID, strExchangeTo, strExchangeFrom)
	{
		m_lngExchangeToID=lngExchangeToID;
		m_strExchangeTo=strExchangeTo;
		m_strExchangeFrom=strExchangeFrom;
	}
	
	this.Name="MqCheckInOutExt ";
	this.OnAfterLoadRec=OnAfterLoadRec;
									  
										
	this.saveBefore=saveBefore;
	this.saveAfter=saveAfter;
	this.cancelAfter=cancelAfter;
	this.setExchangeAsset=setExchangeAsset;
	this.OnLoad_CheckIn=OnLoad_CheckIn;
	this.OnLoad_CheckOut=OnLoad_CheckOut;
	

	function Hide(sName, oDoc)
	{
		if(oDoc)
		{
			var oButton = oDoc.getElementById(sName);
			
			if(oButton)
			{
				oButton.style.display = 'none';
				oButton.style.visibility = 'hidden';
			}
		}
	}

	function Show(sName, oDoc)
	{
		if(oDoc)
		{
			var oButton = oDoc.getElementById(sName);
			
			if(oButton)
			{
				oButton.style.display = '';
				oButton.style.visibility = 'visible';
			}
		}
	}
	
	function SetArrowAndCheckIn_OutAssetPictureUI(ChkInBool) 
	{
		if(ChkInBool == true) 
		{
			Show(CHECKIN_ARROW, GetRecDocument());
			Hide(CHECKOUT_ARROW, GetRecDocument());

		} else 
		{
			Hide(CHECKIN_ARROW, GetRecDocument());
			Show(CHECKOUT_ARROW, GetRecDocument());
			
		}
		SetCurAssetPic();
	}

	function SetCurAssetPic()
	{
		var recID;
		var curAssetStr = "";
		var currentAsset = GetRecDocument().getElementById("currAsset");
		recID = m_CenMainWin.objRecord.GetRecordId();
		curAssetStr = "viewicon.asp?Rec=" + recID + "&Proj=15";
		if(currentAsset)
		{
			currentAsset.firstElementChild.src = curAssetStr;
		}
	}
	
	function SetSaveButtonText(strResCaption, strResTooltip)
	{
		var btnSave=g_VWS.CommandBar().GetElement("lnkActionOK");
		
		if(btnSave)
		{
			btnSave.innerText=g_MqRef.RESX[strResCaption];
			btnSave.title=g_MqRef.RESX[strResTooltip];
			
		}
	}
	
	function SetHeader(sStatus)
	{
		var strTitleRes="WIZARD_CHECKIN_CHECKOUT_ASSET_TITLE";
		var strDescRes="WIZARD_CHECKIN_CHECKOUT_ASSET_DESCRIPTION";
		
		if(m_CenMainWin){
			Hide("cmdEmailIssue", m_CenMainWin.document);
			Hide("cmdEmailConv", m_CenMainWin.document);
			
			if(m_lngExchangeToID>0){
				Hide("cmdHistory", m_CenMainWin.document);
				strTitleRes="SCAN_EXCHANGE_ASSETS_TITLE";
				strDescRes="SCAN_EXCHANGE_ASSETS_DESC";
				
			}else{
				Show("cmdHistory", m_CenMainWin.document);
							
				if(sStatus==STATUS_ASSIGNED || sStatus==STATUS_LOST || sStatus==STATUS_STATUS_REQUESTED){ //Assigned, Lost, Status Requested
					strTitleRes="WIZARD_CHECKIN_ASSET_TITLE";
					strDescRes="WIZARD_CHECKIN_CHECKOUT_ASSET_DESCRIPTION";
				}else{
					//if (sStatus==STATUS_STORAGE){  // Storage
					strTitleRes="WIZARD_CHECKOUT_ASSET_TITLE";
					strDescRes="WIZARD_CHECKOUT_CHECKIN_ASSET_DESCRIPTION";
				}
			}
				
			m_CenMainWin.WIZARD_TITLE_EDIT=g_MqRef.MqStr.Format(g_MqRef.RESX[strTitleRes],"<ValOfField>30</ValOfField>");
			m_CenMainWin.WIZARD_DESCRIPTION_EDIT=g_MqRef.MqStr.Format(g_MqRef.RESX[strDescRes], "<ValOfField>30</ValOfField>");

			oCenMn.objRecord.OnAfterLoad();
		}
	}

	function GetRecDocument()
	{
		return g_VWS.RecordMgr().CurrentRecord().GetHTMLDocObj();
	}
	
	WriteConsole("MqCheckInOutExt: Initializing the extension " + this.Name);		
}
